IF OBJECT_ID ('P_EST_PROD_RESULTADO_BALANCO') IS NOT NULL 
    BEGIN
	   DROP PROCEDURE P_EST_PROD_RESULTADO_BALANCO; 
    END 
GO
CREATE PROCEDURE P_EST_PROD_RESULTADO_BALANCO (@CD_EMP INT ,@CD_FILIAL INT,@CD_BALAN INT , @CD_ARV_MERC_LINHA VARCHAR (8000)) 
AS
SET NOCOUNT ON; 
 ------------------------------------------------------------------------------------------------------------------------------------------
	   CREATE TABLE #CUSTO_BALAN
	   (CD_EMP    INT,
	    CD_FILIAL INT,
	    CD_BALAN  BIGINT,
	    CD_PROD   BIGINT,
	    VLR_CUSTO MONEY
	   );
	   CREATE TABLE #TEMP_ARV_MERCACDOLOGIA
	   (CD_EMP            INT,
	    CD_PROD           BIGINT,
	    CD_ARV_MERC_LINHA INT,
	    CD_APRES          INT,
	    CD_ARV_MERC_EQUI  INT,
		CD_ARV_MERC_CATEG INT
	   );
------------------------------------------------------------------------------------------------------------------------------------------
	   IF @CD_ARV_MERC_LINHA = ''
		  BEGIN
			 INSERT INTO #TEMP_ARV_MERCACDOLOGIA
				   SELECT CD_EMP,
						CD_PROD,
						CD_ARV_MERC_LINHA,
						CD_APRES,
						CD_ARV_MERC_EQUI,
						CD_ARV_MERC_CATEG
				   FROM EST_PROD_EST_ARV_MERCADOLOGICA;
		  END;
		  ELSE
		  BEGIN
			 INSERT INTO #TEMP_ARV_MERCACDOLOGIA
				   SELECT CD_EMP,
						CD_PROD,
						CD_ARV_MERC_LINHA,
						CD_APRES,
						CD_ARV_MERC_EQUI,
						CD_ARV_MERC_CATEG
				   FROM EST_PROD_EST_ARV_MERCADOLOGICA
				   WHERE CD_ARV_MERC_LINHA IN
	   (
		  SELECT ID
		  FROM UFD_PRM_IN_STRING(@CD_ARV_MERC_LINHA)
	   );
		  END; 
 ------------------------------------------------------------------------------------------------------------------------------------------
    INSERT INTO  #CUSTO_BALAN
		 SELECT IT.CD_EMP,
			    IT.CD_FILIAL,
			    IT.CD_BALAN,
			    IT.CD_PROD,
			    0
		 FROM EST_PROD_BALAN BALAN
			 INNER JOIN EST_PROD_BALAN_IT IT ON BALAN.CD_EMP = IT.CD_EMP
										 AND BALAN.CD_FILIAL = IT.CD_FILIAL
										 AND BALAN.CD_BALAN = IT.CD_BALAN
		 WHERE BALAN.CD_EMP = @CD_EMP
			  AND BALAN.CD_FILIAL = @CD_FILIAL
			  AND BALAN.CD_BALAN = @CD_BALAN
		 GROUP BY IT.CD_EMP,
				IT.CD_FILIAL,
				IT.CD_BALAN,
				IT.CD_PROD;

------------------------------------------------------------------------------------------------------------------------------------------
	   UPDATE IT
		SET
		    VLR_CUSTO = VLR_CUSTO_MD
	   FROM #CUSTO_BALAN IT
		   JOIN EST_PROD_CPL P ON IT.CD_EMP = P.CD_EMP 
								  AND IT.CD_FILIAL = P.CD_FILIAL
								  AND IT.CD_PROD = P.CD_PROD;
								  
	   
------------------------------------------------------------------------------------------------------------------------------------------	       

		  SELECT EST_PROD_BALAN.CD_EMP                                                                                                                                                                                   ,
			    EST_PROD_BALAN.CD_FILIAL                                                                                                                                                                                ,
			    EST_PROD_BALAN.DT_CAD                                                                                                                                                                                   ,
			    EST_PROD_BALAN.CD_BALAN                                                                                                                                                                                 ,
			    EST_PROD_BALAN_IT.CD_PROD                                                                                                                                                                               ,
			    EST_PROD_BALAN_IT.QT_IT                                                                                                                                                                                 ,
			    (EST_PROD_BALAN_IT.QT_IT * EST_PROD_BALAN_IT.VLR_VEND) AS VLR_VEND_ANTES_BALAN                                                                                                                          ,
			    EST_PROD.DS_PROD                                                                                                                                                                                        ,
			    EST_PROD_FABRIC.NM_FABRIC                                                                                                                                                                               ,
			    EST_ARV_MERC_LINHA.DS_ARV_MERC_LINHA                                                                                                                                                                    ,
			    ISNULL(EST_ARV_MERC_EQUIVALENTE.DS_ARV_MERC_EQUI,'NO DEFINIDO') AS DS_ARV_MERC_EQUI                                                                                                                    ,
			    ISNULL(EST_ARV_MERC_APRESENTACAO.DS_APRES,'0')                   AS DS_APRES                                                                                                                            ,
			    EST_PROD_CURVA_SIGLA.DS_SIGLA                                                                                                                                                                           ,
			    EST_PROD_BALAN_IT.QT_IT_BALAN                                                                                                                                                                           ,
			    (EST_PROD_BALAN_IT.QT_IT_BALAN  * EST_PROD_BALAN_IT.VLR_VEND)                                                                                                                                         AS VLR_VEND_APOS_BALAN       ,
			    (EST_PROD_BALAN_IT.QT_IT_BALAN  * EST_PROD_BALAN_IT.VLR_CP)                                                                                                                                           AS VLR_CUSTO_APOS_BALAN      ,
			    (EST_PROD_BALAN_IT.QT_IT        * EST_PROD_BALAN_IT.VLR_CP)                                                                                                                                           AS VLR_CUSTO_ANTES_BALAN     ,
			    (EST_PROD_BALAN_IT.QT_IT_BALAN  - EST_PROD_BALAN_IT.QT_IT)                                                                                                                                            AS QTDE_DIVERG               ,
			    ((EST_PROD_BALAN_IT.QT_IT_BALAN - EST_PROD_BALAN_IT.QT_IT) * EST_PROD_BALAN_IT.VLR_VEND)                                                                                                              AS VLR_DIVERG_VENDA          ,
			    ((EST_PROD_BALAN_IT.QT_IT_BALAN - EST_PROD_BALAN_IT.QT_IT) * EST_PROD_BALAN_IT.VLR_CP)                                                                                                               AS VLR_DIVERG_CUSTO          ,
			    (EST_PROD_BALAN_IT.QT_IT_BALAN  * AUX.VLR_CUSTO) AS VLR_CUSTO_NOVO_APOS_BALAN ,
			    (EST_PROD_BALAN_IT.QT_IT        * AUX.VLR_CUSTO) AS VLR_CUSTO_NOVO_ANTES_BALAN,
			    ((EST_PROD_BALAN_IT.QT_IT_BALAN - EST_PROD_BALAN_IT.QT_IT) * AUX.VLR_CUSTO) AS VLR_DIVERG_CUSTO_NOVO     ,
			    CASE
					 WHEN
						   (
								EST_PROD_BALAN_IT.QT_IT_BALAN - EST_PROD_BALAN_IT.QT_IT
						   )
						   > 0
					 THEN 'POSITIVO'
					 WHEN
						   (
								EST_PROD_BALAN_IT.QT_IT_BALAN - EST_PROD_BALAN_IT.QT_IT
						   )
						   = 0
					 THEN 'SEM DIVERGENCIA'
					 ELSE 'NEGATIVO'
			    END TIPO_DIVERG,
			    ENDERECO       ,
			    CASE
					 WHEN EST_PROD_BALAN_IT.QT_IT <> EST_PROD_BALAN_IT.QT_IT_BALAN
					 THEN 'SIM'
					 ELSE 'NAO'
			    END AS DIFERENCA                                    ,
			    1   AS QTDE_SKU                                     ,
			    EST_ARV_MERC_CATEGORIA.DS_ARV_MERC_CATEG            ,
			    EST_ARV_MERC_DEPTO.DS_ARV_MERC_DEPTO                ,
			    EST_ARV_MERC_AREA_ATENDIMENTO.DS_ARV_MERC_AREA_ATEND,
			    ISNULL(
			    (SELECT TOP 1 EST_PROD_CD_BARRA.CD_BARRA
			    FROM    EST_PROD_CD_BARRA
			    WHERE   EST_PROD_CD_BARRA.CD_EMP  = EST_PROD_BALAN_IT.CD_EMP
			    AND     EST_PROD_CD_BARRA.CD_PROD = EST_PROD_BALAN_IT.CD_PROD
			    )
			    ,'') AS CD_BARRA
		  FROM   EST_ARV_MERC_EQUIVALENTE
			    RIGHT OUTER JOIN EST_ARV_MERC_APRESENTACAO
			    INNER JOIN EST_PROD_CPL
			    INNER JOIN EST_PROD_BALAN
			    INNER JOIN EST_PROD_BALAN_IT
			    ON     EST_PROD_BALAN.CD_EMP    = EST_PROD_BALAN_IT.CD_EMP
			    AND    EST_PROD_BALAN.CD_FILIAL = EST_PROD_BALAN_IT.CD_FILIAL
			    AND    EST_PROD_BALAN.CD_BALAN  = EST_PROD_BALAN_IT.CD_BALAN
			    INNER JOIN EST_PROD
			    ON     EST_PROD_BALAN_IT.CD_EMP  = EST_PROD.CD_EMP
			    AND    EST_PROD_BALAN_IT.CD_PROD = EST_PROD.CD_PROD
			    INNER JOIN #TEMP_ARV_MERCACDOLOGIA EST_PROD_EST_ARV_MERCADOLOGICA
			    ON     EST_PROD.CD_EMP  = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP
			    AND    EST_PROD.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD
			    INNER JOIN #CUSTO_BALAN AUX ON 
			    AUX.CD_EMP = EST_PROD_BALAN_IT.CD_EMP
			    AND AUX.CD_FILIAL =EST_PROD_BALAN_IT.CD_FILIAL
			    AND AUX.CD_BALAN = EST_PROD_BALAN_IT.CD_BALAN
			    AND AUX.CD_PROD =EST_PROD_BALAN_IT.CD_PROD
			    INNER JOIN EST_ARV_MERC_LINHA
			    ON     EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA = EST_ARV_MERC_LINHA.CD_ARV_MERC_LINHA
			    AND    EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP            = EST_ARV_MERC_LINHA.CD_EMP
			    INNER JOIN EST_PROD_FABRIC
			    ON     EST_PROD.CD_FABRIC     = EST_PROD_FABRIC.CD_FABRIC
			    ON     EST_PROD_CPL.CD_EMP    = EST_PROD_BALAN_IT.CD_EMP
			    AND    EST_PROD_CPL.CD_FILIAL = EST_PROD_BALAN_IT.CD_FILIAL
			    AND    EST_PROD_CPL.CD_PROD   = EST_PROD_BALAN_IT.CD_PROD
			    INNER JOIN EST_PROD_CURVA_SIGLA
			    ON     EST_PROD_CPL.CD_EMP   = EST_PROD_CURVA_SIGLA.CD_EMP
			    AND    EST_PROD_CPL.CD_SIGLA = EST_PROD_CURVA_SIGLA.CD_SIGLA
			    INNER JOIN V_EST_PROD_PRT_GVT
			    ON     EST_PROD_CPL.CD_EMP                       = V_EST_PROD_PRT_GVT.CD_EMP
			    AND    EST_PROD_CPL.PRAT                         = V_EST_PROD_PRT_GVT.CD_PRT
			    AND    EST_PROD_CPL.GAV                          = V_EST_PROD_PRT_GVT.CD_GVT
			    ON     EST_ARV_MERC_APRESENTACAO.CD_APRES        = EST_PROD_EST_ARV_MERCADOLOGICA.CD_APRES
			    AND    EST_ARV_MERC_APRESENTACAO.CD_EMP          = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP
			    ON     EST_ARV_MERC_EQUIVALENTE.CD_EMP           = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP
			    AND    EST_ARV_MERC_EQUIVALENTE.CD_ARV_MERC_EQUI = EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_EQUI
			    INNER JOIN EST_ARV_MERC_CATEGORIA
			    ON     EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP            = EST_ARV_MERC_CATEGORIA.CD_EMP
			    AND    EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_CATEG = EST_ARV_MERC_CATEGORIA.CD_ARV_MERC_CATEG
			    INNER JOIN EST_ARV_MERC_DEPTO
			    ON     EST_ARV_MERC_CATEGORIA.CD_EMP            = EST_ARV_MERC_DEPTO.CD_EMP
			    AND    EST_ARV_MERC_CATEGORIA.CD_ARV_MERC_DEPTO = EST_ARV_MERC_DEPTO.CD_ARV_MERC_DEPTO
			    INNER JOIN EST_ARV_MERC_AREA_ATENDIMENTO
			    ON     EST_ARV_MERC_DEPTO.CD_EMP                 = EST_ARV_MERC_AREA_ATENDIMENTO.CD_EMP
			    AND    EST_ARV_MERC_DEPTO.CD_ARV_MERC_AREA_ATEND = EST_ARV_MERC_AREA_ATENDIMENTO.CD_ARV_MERC_AREA_ATEND
		  WHERE  EST_PROD_BALAN.CD_EMP                            =@CD_EMP
		  AND    EST_PROD_BALAN.CD_FILIAL                         = @CD_FILIAL
		  AND    EST_PROD_BALAN.CD_BALAN                          = @CD_BALAN  